<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddStatusPendidikanToEducation extends Migration
{
    public function up()
    {
        $this->forge->addColumn('education', [
            'status_pendidikan' => [
                'type' => 'ENUM',
                'constraint' => ['lulus', 'sedang_menempuh', 'tidak_lulus', 'cuti', 'pindah'],
                'default' => 'lulus',
                'null' => false,
                'after' => 'tahun_selesai'
            ]
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('education', 'status_pendidikan');
    }
}
